(function() {
  //    FILE:UserModel
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  define(['Backbone', 'Backbone.LocalStorage', 'moment', 'models/request/RequestModel'], function(Backbone, LocalStorage, Moment, RequestModel) {
    var UserModel;
    return UserModel = (function() {
      class UserModel extends Backbone.Model {
        initialize() {
          return this.reqMdl = new RequestModel();
        }

        //# MENU VIEW
        __enabled_contacts() {
          var ref, ref1;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          return ((ref = _.where(this.pp, {
            'key': 'Contacts:enabled'
          })) != null ? (ref1 = ref[0]) != null ? ref1['value'] : void 0 : void 0) === 1;
        }

        __enabled_projects() {
          var ref, ref1;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          return ((ref = _.where(this.pp, {
            'key': 'Projects:enabled'
          })) != null ? (ref1 = ref[0]) != null ? ref1['value'] : void 0 : void 0) === 1;
        }

        __enabled_object_browser() {
          var ll;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          ll = _.where(this.get('ProfileProperties').ProfileProperty, {
            "key": "Events:canViewMultiple"
          });
          if ((ll != null ? ll.length : void 0) > 0) {
            return ll[0].value;
          } else {
            return 0;
          }
        }

        __enabled_pdf_reports() {
          return this.get('hasPDFPrinterAvailable');
        }

        __enabled_todos() {
          var ref, ref1;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          return ((ref = _.where(this.pp, {
            'key': 'Todos:enabled'
          })) != null ? (ref1 = ref[0]) != null ? ref1['value'] : void 0 : void 0) === 1;
        }

        __enabled_notifications() {
          var ref, ref1;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          return ((ref = _.where(this.pp, {
            'key': 'Notifications:enabled'
          })) != null ? (ref1 = ref[0]) != null ? ref1['value'] : void 0 : void 0) === 1;
        }

        //# NOTIFICATION LIST
        __has_unread_notifications() {
          if (this.get('notificationsNotReadCount') > 0) {
            return true;
          } else {
            return false;
          }
        }

        //#EVENT LIST
        __can_view_event_in_time_frame(day) {
          var maxTime, minTime;
          if (this.get('eventsViewableTimeFrameStart') && this.get('eventsViewableTimeFrameStop')) {
            minTime = Moment(this.get('eventsViewableTimeFrameStart'));
            maxTime = Moment(this.get('eventsViewableTimeFrameStop'));
            if (day >= minTime && day <= maxTime) {
              return true;
            } else {
              return false;
            }
          } else {
            return true;
          }
        }

        __can_create_event_in_time_frame(day) {
          var maxTime, minTime;
          if (this.get('eventsBookableTimeFrameStart') && this.get('eventsBookableTimeFrameStop')) {
            minTime = Moment(this.get('eventsBookableTimeFrameStart'));
            maxTime = Moment(this.get('eventsBookableTimeFrameStop'));
            if (day >= minTime && day <= maxTime) {
              return true;
            } else {
              return false;
            }
          } else {
            return true;
          }
        }

        __get_holiday(day) {
          var isHoliday, ref;
          isHoliday = null;
          _.each((ref = this.get("Holidays")) != null ? ref.Holiday : void 0, function(hol) {
            if (day === hol.day) {
              return isHoliday = hol;
            }
          });
          return isHoliday;
        }

        // TODO ADD IN DIVISION PERMISIONS

          //#CONTACTS
        __can_view_related_events_to_contact() {
          var ref, ref1;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          return ((ref = _.where(this.pp, {
            'key': "Contacts:Events:allowShowingEventsRelatedToContact"
          })) != null ? (ref1 = ref[0]) != null ? ref1['value'] : void 0 : void 0) === 1;
        }

        __can_edit_all_contacts() {
          var obj, ref, ref1;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          return obj = ((ref = _.where(this.pp, {
            'key': "Contacts:AllowEditingContact:always"
          })) != null ? (ref1 = ref[0]) != null ? ref1.value : void 0 : void 0) === 1;
        }

        __can_edit_division_contacts() {
          var ref, ref1;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          return ((ref = _.where(this.pp, {
            'key': "Contacts:AllowEditingContact:ifItIsInHisDivision"
          })) != null ? (ref1 = ref[0]) != null ? ref1.value : void 0 : void 0) === 1;
        }

        __can_not_edit_contact_if_resource() {
          var ref, ref1;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          return ((ref = _.where(this.pp, {
            'key': "Contacts:AllowEditingContact:notIfTypeIsResource"
          })) != null ? (ref1 = ref[0]) != null ? ref1.value : void 0 : void 0) === 1;
        }

        __can_not_edit_contact_if_client() {
          var ref, ref1;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          return ((ref = _.where(this.pp, {
            'key': "Contacts:AllowEditingContact:notIfTypeIsClient"
          })) != null ? (ref1 = ref[0]) != null ? ref1.value : void 0 : void 0) === 1;
        }

        //# CREATION PERMISSION HIMSELF
        __can_create_tasks_himself() {
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          if (_.where(this.pp, {
            "key": "Events:Objects:Himself:createTasks"
          })[0]['value'] === 'yes') {
            return true;
          } else {
            return false;
          }
        }

        __can_create_requests_himself() {
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          if (_.where(this.pp, {
            "key": "Events:Objects:Himself:createRequests"
          })[0]['value'] === 'yes') {
            return true;
          } else {
            return false;
          }
        }

        __can_create_bookings_himself() {
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          if (_.where(this.pp, {
            "key": "Events:Objects:Himself:createBookings"
          })[0]['value'] === 'yes') {
            return true;
          } else {
            return false;
          }
        }

        __can_create_personnel_himself() {
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          if (_.where(this.pp, {
            "key": "Events:Objects:Himself:createPersonnel"
          })[0]['value'] === 'yes') {
            return true;
          } else {
            return false;
          }
        }

        __can_create_projects() {
          var always, divisions, ref, ref1, ref2, ref3, ref4, ref5, relation;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          always = ((ref = _.where(this.pp, {
            'key': "Projects:AllowEditingProject:always"
          })) != null ? (ref1 = ref[0]) != null ? ref1.value : void 0 : void 0) === 1;
          divisions = ((ref2 = _.where(this.pp, {
            'key': "Projects:AllowEditingProject:ifItIsInHisDivision"
          })) != null ? (ref3 = ref2[0]) != null ? ref3.value : void 0 : void 0) === 1;
          relation = ((ref4 = _.where(this.pp, {
            'key': "Projects:AllowEditingProject:ifHeHasARelationToIt"
          })) != null ? (ref5 = ref4[0]) != null ? ref5.value : void 0 : void 0) === 1;
          return always || divisions || relation;
        }

        //# TIMEREPORTS
        __enabled_timereports() {
          var ref, ref1;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          return ((ref = _.where(this.pp, {
            'key': 'Timereports:enabled'
          })) != null ? (ref1 = ref[0]) != null ? ref1['value'] : void 0 : void 0) === 1;
        }

        __can_timereport_tomorrow() {
          var ref, ref1;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          return ((ref = _.where(this.pp, {
            'key': 'Timereports:AllowEditingTimereport:allowReportingIntoNextDay'
          })) != null ? (ref1 = ref[0]) != null ? ref1['value'] : void 0 : void 0) === 1;
        }

        __can_timereport_all() {
          var property, ref;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          property = (ref = _.where(this.pp, {
            'key': 'Timereports:AllowEditingTimereport:allowApplyingNewBreaksToAllInvolved'
          })) != null ? ref[0] : void 0;
          return !(property != null ? property['na'] : void 0) && (property != null ? property['value'] : void 0) === 1;
        }

        __enabled_time_travel_expenses() {
          return this.get('usesTravelExpenses');
        }

        __can_timereport_all_projects() {
          var ref, ref1;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          return ((ref = _.where(this.pp, {
            'key': 'Timereports:AllowTimereportingOnProjects:allProjects'
          })) != null ? (ref1 = ref[0]) != null ? ref1['value'] : void 0 : void 0) === 1;
        }

        __can_timereport_in_his_division_projects() {
          var ref, ref1;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          return ((ref = _.where(this.pp, {
            'key': 'Timereports:AllowTimereportingOnProjects:projectsThatAreInHisDivision'
          })) != null ? (ref1 = ref[0]) != null ? ref1['value'] : void 0 : void 0) === 1;
        }

        __can_timereport_relation_projects() {
          var ref, ref1;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          return ((ref = _.where(this.pp, {
            'key': 'Timereports:AllowTimereportingOnProjects:projectsThatHeHasARelationTo'
          })) != null ? (ref1 = ref[0]) != null ? ref1['value'] : void 0 : void 0) === 1;
        }

        __default_time_breaks() {
          return this.get('DefaultBreaks')['DefaultBreak'];
        }

        //# REQUEST TYPE
        __must_select_request_type() {
          var ll;
          ll = _.where(this.get('ProfileProperties').ProfileProperty, {
            "key": "Events:Objects:Himself:userMustSelectRequestType"
          });
          if ((ll != null ? ll.length : void 0) > 0) {
            return ll[0].value;
          } else {
            return 0;
          }
        }

        __show_request_recipient_users_list() {
          var ll;
          ll = _.where(this.get('ProfileProperties').ProfileProperty, {
            "key": "Events:Objects:Himself:showRequestRecipientUsersList"
          });
          if ((ll != null ? ll.length : void 0) > 0) {
            return ll[0].value;
          } else {
            return 0;
          }
        }

        __can_modify_approved_requests() {
          var ll;
          ll = _.where(this.get('ProfileProperties').ProfileProperty, {
            "key": "Events:Objects:Himself:canModifyApprovedRequests"
          });
          if ((ll != null ? ll.length : void 0) > 0) {
            return ll[0].value;
          } else {
            return 0;
          }
        }

        //# TODOS
        __show_todos_all_projects() {
          var ll;
          ll = _.where(this.get('ProfileProperties').ProfileProperty, {
            "key": "Todos:AllowTodosOnProjects:allProjects"
          });
          if ((ll != null ? ll.length : void 0) > 0) {
            return ll[0].value;
          } else {
            return 0;
          }
        }

        __show_todos_division_projects() {
          var ll;
          ll = _.where(this.get('ProfileProperties').ProfileProperty, {
            "key": "Todos:AllowTodosOnProjects:projectsThatAreInHisDivision"
          });
          if ((ll != null ? ll.length : void 0) > 0) {
            return ll[0].value;
          } else {
            return 0;
          }
        }

        __show_todos_relation_projects() {
          var ll;
          ll = _.where(this.get('ProfileProperties').ProfileProperty, {
            "key": "Todos:AllowTodosOnProjects:projectsThatHeHasARelationTo"
          });
          if ((ll != null ? ll.length : void 0) > 0) {
            return ll[0].value;
          } else {
            return 0;
          }
        }

        //#PASSWORD
        __can_change_password() {
          var ref, ref1;
          this.pp = this.get('ProfileProperties')['ProfileProperty'];
          return ((ref = _.where(this.pp, {
            'key': "Miscellaneous:allowUserToChangePassword"
          })) != null ? (ref1 = ref[0]) != null ? ref1['value'] : void 0 : void 0) === 1;
        }

        set_user_password(oldP, newP) {
          var jsonReq, response, that, xmlReq;
          jsonReq = this.reqMdl.get('JChangePassword');
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', this.get('sessionID'));
          this.reqMdl.__setNodeValue(jsonReq, 'oldPassword', oldP);
          this.reqMdl.__setNodeValue(jsonReq, 'newPassword', newP);
          xmlReq = this.reqMdl.__getXML(jsonReq);
          that = this;
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          response.done(function(data, textStatus, jqXHR) {
            var jsonObj;
            jsonObj = data;
            //console.log data
            if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
              window.localStorage.clear();
              window.location.href = 'index.html?expired=1';
            }
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              return that.trigger('password_updated');
            } else {
              that.server_message = jsonObj.Result.error;
              return that.trigger('password_error');
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {
            return $.mobile.loading('hide');
          });
          return this;
        }

        // LOG OUT
        disconnect() {
          var jsonReq, xmlReq;
          jsonReq = this.reqMdl.get('JDisconnect');
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', this.get('sessionID'));
          xmlReq = this.reqMdl.__getXML(jsonReq);
          return this.reqMdl.__send_server_xmlrequest(xmlReq);
        }

        // SETTER SHIFT
        set_user_shift(eventID, userIsAvailable) {
          var jsonReq, xmlReq;
          jsonReq = this.reqMdl.get('JSetShiftAvailability');
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', this.get('sessionID'));
          this.reqMdl.__setNodeValue(jsonReq, 'userIsAvailable', userIsAvailable);
          this.reqMdl.__setNodeValue(jsonReq, 'eventID', eventID);
          xmlReq = this.reqMdl.__getXML(jsonReq);
          // RETURN PROMISE
          return this.reqMdl.__send_server_xmlrequest(xmlReq);
        }

      };

      UserModel.prototype.localStorage = new LocalStorage('Settings');

      return UserModel;

    }).call(this);
  });

}).call(this);
